#!/bin/sh
#
# This script installs the unified NVidia driver.  It basically boils down
# to three commands; you could just as easily run them by hand.
#
# This driver and installer script are intended to be used within BeOS
# ( http://www.be.com/products/freebeos/ ).  If you are not already within
# BeOS, reboot into BeOS before attempting installation.
#
# Q: HELP!  This file opened in an editor!  What do I do?
#
# A: This happens to some BeOS users; I have not yet figured out why.  If
#    this happens to you, try the following procedure:
#
#	o From the BeOS menu, open a command line Terminal by selecting
#	  BeOS->Applications->Terminal.
#	o Using the mouse, drag the icon for the install-nvidia-driver.sh
#	  file into the Terminal window.  The full path name of the file will
#	  automatically be entered on the command line.
#	o Press ENTER in the Terminal window.  The install process should
#	  begin.
#
# Bugs:
#	This script is not terribly robust.  Try not to stress it; 'bash'
#	isn't my first language.
#
# Leo L. Schwab						2001.01.04
#

ask() {
  until
    echo -n "$1"
    if ! read
    then
      echo EOF
      exit 1
    fi
    case $REPLY in 
      y|yes|n|no) true ;;
      *) false;;
    esac
  do
  echo please answer yes or no
  done
  case $REPLY in n|no) return 1 ;; esac
  return 0
}


# Where to find stuff.
#
ARCHIVEDIR=`dirname "$0"`
ARCHIVE="nvidia-2001_07_31.zip"
DRIVERDIR="/system/add-ons/kernel/drivers/bin"
OLDDRIVERS="rivatnt riva128"


# Check if we're launched from the Tracker
#
if [ ! -t 1 ]; then
	# Launched from Tracker; open a shell window and run from there.
	export INWINDOW=1
	Terminal -t "Installer Diagnostic Output" /bin/sh "$0"
	unset INWINDOW
	exit 0
fi


# Say hello, make the user read the README file.
#
msg=$'Experimental Unified NVidia Graphics Driver\n\n'
msg="$msg"$'This script will install the experimental unified driver for '
msg="$msg"$'NVidia-based graphics cards.\n\n'
msg="$msg"$'Would you like to read the "NVidia-README" file for important '
msg="$msg"$'information?'

# No, you don't get a choice :-).
if [ `alert "$msg" Yes Yes` == "Yes" ]; then
	StyledEdit "$ARCHIVEDIR/NVidia-README"
fi


# Confirm desire to install.
#
msg=$'Last chance to back out.\n\n'
msg="$msg"$'Do you wish to install the driver?'

if [ `alert --warning "$msg" Install Abort` == "Abort" ]; then
	alert --stop "Installation aborted." "Exit" > /dev/null 2>&1
	exit 0
fi

# Make sure we can find the driver archive file.
#
if [ ! -e "$ARCHIVEDIR/$ARCHIVE" ]; then
	msg="I can't find the file named \"$ARCHIVE\", which contains the"
	msg="$msg driver binaries.  I expected to find it in the directory:"
	msg="$msg"$'\n\n"'$ARCHIVEDIR$'"\n\n'
	msg="$msg""but it doesn't seem to be there.  Please"
	msg="$msg confirm that you completely unpacked the downloaded archive"
	msg="$msg and try again."
	alert --stop "$msg" "Drat" > /dev/null 2>&1
	exit 1
fi


# Disable old drivers superseded by this one.
#
echo "Disabling obsolete drivers:"
for drv in $OLDDRIVERS; do
	if [ -e $DRIVERDIR/$drv ]; then
		echo "...$drv"
		mv $DRIVERDIR/$drv $DRIVERDIR/$drv-disabled
	fi
done
unset drv
echo "Done."

# Unpack driver binaries into their correct locations.
#
echo
echo "Unpacking unified NVidia driver..."
unzip -o "$ARCHIVEDIR/$ARCHIVE" -d /
echo
echo "Done!"

# All done!
#
msg=$'Installation completed!\n\nReboot BeOS to use your new drivers.'
alert "$msg" "Exit" > /dev/null 2>&1

unset msg
